﻿open System
open System.Runtime.InteropServices
open System.Runtime.CompilerServices

open ObjectLayoutInspector;


[<Struct; StructLayout(LayoutKind.Sequential, Pack = 1)>]
type V = 
    val Value: byte
    new(v) = { Value = v }

[<Struct>]
type TestStruct =
    val Field1: V
    val Field2: V
    val Field3: V
    new(f1,f2,f3) = { Field1=f1;Field2=f2;Field3=f3}

[<Struct; StructLayout(LayoutKind.Sequential, Pack = 1)>]
type TestStructPacked =
    val Field1: V
    val Field2: V
    val Field3: V
    new(f1,f2,f3) = { Field1=f1;Field2=f2;Field3=f3}

type TestClass =
    val Field1: V
    val Field2: V
    val Field3: V
    new(f1,f2,f3) = { Field1=f1;Field2=f2;Field3=f3}

[<Class; StructLayout(LayoutKind.Sequential, Pack = 1)>]
type TestClassPacked =
    val Field1: V
    val Field2: V
    val Field3: V
    new(f1,f2,f3) = { Field1=f1;Field2=f2;Field3=f3}

type TestRecord = {
    Field1: V
    Field2: V
    Field3: V
}

[<Struct>]
type TestStructRecord = {
    Field1: V
    Field2: V
    Field3: V
}

type TestSingleDU = TestSingleDU of V * V * V

[<Struct>]
type TestStructSingleDU = TestStructSingleDU of V * V * V

type TestDU = 
    | Case1 of V * V * V
    | Case2 of V * V * V

[<Struct>]
type TestStructDU = 
    | Case1 of c1f1:V * c1f2:V * c1f3:V
    | Case2 of c2f1:V * c2f2:V * c2f3:V

[<EntryPoint>]
let main argv =
    TypeLayout.PrintLayout<V> true;
    TypeLayout.PrintLayout<TestStruct> true;
    TypeLayout.PrintLayout<TestStructPacked> true;
    TypeLayout.PrintLayout<TestClass> true;
    TypeLayout.PrintLayout<TestClassPacked> true;
    TypeLayout.PrintLayout<TestRecord> true;
    TypeLayout.PrintLayout<TestStructRecord> true;
    TypeLayout.PrintLayout<TestSingleDU> true;
    TypeLayout.PrintLayout<TestStructSingleDU> true;
    TypeLayout.PrintLayout<TestDU> true;
    TypeLayout.PrintLayout<TestStructDU> true;

    0 // return an integer exit code
