#! /usr/bin/env dcli

/// dcli script generated by:
/// dcli create %scriptname%
///
/// See
/// https://pub.dev/packages/dcli#-installing-tab-
///
/// For details on installing dcli.
///
void main(List<String> args) {
  /// good - no error as expected
  withSync<void>(() => syncCallback(1));
  print('from 1');

  /// bad - no error - should error on unawaited future
  withSync(() => asyncCallback(2));
  print('from 2');

  // bad - has error as expected
  // withAsync(() => syncCallback(3));

  // good - no error as expected
  withAsync(() => asyncCallback(4));
  print('from 4');
}

Future<R> withAsync<R>(Future<R> Function() callback) => callback();

R withSync<R>(R Function() callback) => callback();

Future<void> asyncCallback(int count) =>
    Future.delayed(const Duration(seconds: 3), () => print(count));

void syncCallback(int count) => print(count);
