package com.example.demo;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.context.MessageSource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.TestPropertySource;

import java.util.Map;

import static org.assertj.core.api.Assertions.assertThat;
import static org.springframework.http.HttpMethod.GET;

@SpringBootTest(webEnvironment= SpringBootTest.WebEnvironment.RANDOM_PORT)
class SendErrorTests {

	@Autowired
	private TestRestTemplate testRestTemplate;

	@Test
	void sendErrorShouldProduceProblemDetails() {
		ResponseEntity<Map<String, Object>> resp = testRestTemplate.exchange(RequestEntity.method(GET, "/").build(),
				new ParameterizedTypeReference<Map<String, Object>>() {
				});
		assertThat(resp.getBody()).containsKey("detail");
	}

}
