package no.test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyOverride {

	private static final Logger logger = LoggerFactory.getLogger(PropertyOverride.class);

	private final String property1;
	private final String property2;
	private final String property3;
	private final String property4;
	private final String property5;

	@SuppressWarnings("unused")
	public void init() {
		logger.info(String.format("Property1='%s' (expecting 'default1')", property1));
		logger.info(String.format("Property2='%s' (expecting 'application2')", property2));
		logger.info(String.format("Property3='%s' (expecting 'common3')", property3));
		logger.info(String.format("Property4='%s' (expecting 'profile4')", property4));
		logger.info(String.format("Property5='%s' (expecting 'local5')", property5));
	}

	public PropertyOverride(final String property1, final String property2, final String property3, final String property4, final String property5) {
		this.property1 = property1;
		this.property2 = property2;
		this.property3 = property3;
		this.property4 = property4;
		this.property5 = property5;
	}

}
