package no.test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@SuppressWarnings("unused")
@Component
@Profile({"profile1"})
public class PropertyOverrideByProfile {

	private static final Logger logger = LoggerFactory.getLogger(PropertyOverrideByProfile.class);

	@Value("${my.spring.profile.property1}")private String property1;
	@Value("${my.spring.profile.property2}")private String property2;
	@Value("${my.spring.profile.property3}")private String property3;
	@Value("${my.spring.profile.property4}")private String property4;
	@Value("${my.spring.profile.property5}")private String property5;

	@PostConstruct
	public void init() {
		logger.info(String.format("Property1='%s' (expecting 'default1')", property1));
		logger.info(String.format("Property2='%s' (expecting 'application2')", property2));
		logger.info(String.format("Property3='%s' (expecting 'common3')", property3));
		logger.info(String.format("Property4='%s' (expecting 'profile4')", property4));
		logger.info(String.format("Property5='%s' (expecting 'local5')", property5));
	}

}
